<?php

/* w tym miejscu naley zdefiniowa odpowiedni mechanizm weryfikacji nazwy 
   i hasa uytkownika, np. sprawdzenie wartoci w bazie danych */
$users = array('dawid' => 'fadj&32',
               'adam'  => '8HEj838');
$realm = 'Moja strona';

$username = pc_validate_digest($realm, $users);

//Ponisza instrukcja nie zostanie wykonana, jeli dane uwierzytelniajce s niepoprawne
print "Witaj, " . htmlentities($username);

function pc_validate_digest($realm, $users) {
    // Zakoczenie z bdem, jeli klient nie dostarczy wartoci skrtu
    if (! isset($_SERVER['PHP_AUTH_DIGEST'])) {
        pc_send_digest($realm);
    }
    // Zakoczenie z bdem, jeli nie mona przeanalizowa wartoci skrtu
    $username = pc_parse_digest($_SERVER['PHP_AUTH_DIGEST'], $realm, $users);
    if ($username === flase) {
        pc_send_digest($realm);
    }
    // W skrcie zostaa zawarta poprawna nazwa uytkownika
    return $username;
}

function pc_send_digest($realm) {
    header('http/1.0 401 Unauthorized');
    $nonce = md5(uniqid());
    $opaque = md5($realm);
    header("WWW-Authenticate: Digest realm=\"$realm\" qop=\"auth\" ".
           "nonce=\"$nonce\" opaque=\"$opaque\"");
    echo "Uzyskanie dostpu do strony wymaga podania poprawnej nazwy uytkownika i 
          hasa.";
    exit;
}

function pc_parse_digest($digest, $realm, $users) {
    // W nagwku skrtu musz wystpowa nastpujce parametry:
    // username, uri, qop, cnotce, nc oraz response
    $digest_info = array();
    foreach (array('username','uri','nonce','cnonce','response') as $part) {
        // Separatorem mog by znaki (') lub (") lub brak jakiegokolwiek 
        // znaku (w przypadku pl qop i nc)
        if (preg_match('/'.$part.'=([\'"]?)(.*?)\1/', $digest, $match)) {
            // Element zosta znaleziony i zostanie zapamitany.
            $digest_info[$part] = $match[2];
        } else {
            // Jeli element nie wystpuje, skrt jest niepoprawny.
            return false;
        }
    }
    // Sprawdzenie, czy zostaa przekazana poprawna warto qop
    if (preg_match('/qop=auth(,|$)/', $digest)) {
        $digest_info['qop'] = 'auth';
    } else {
        return false;
    }
    // Sprawdzenie, czy zostaa przekazana poprawna liczba wartoci nonce
    if (preg_match('/nc=([0-9a-f]{8})(,|$)/', $digest, $match)) {
        $digest_info['nc'] = $match[1];
    } else {
        return false;
    }

    // Wszystkie niezbdne wartoci zostay wyodrbnione z nagwka, mona wic wykona
    // obliczenia sprawdzajce, czy dostarczone dane s poprawne.
    //
    // Wspomniane obliczenia s opisane w punktach 3.2.2, 3.2.2.1 oraz 3.2.2.2 dokumentu
    // RFC 2617.
    // Wykorzystywany algorytm do MD5
    $A1 = $digest_info['username'] . ':' . $realm . ':' .
          $users[$digest_info['username']];
    // Parametr qop ma warto 'auth'
    $A2 = $_SERVER['REQUEST_METHOD'] . ':' . $digest_info['uri'];
    $request_digest = md5(implode(':', array(md5($A1), $digest_info['nonce'], 
                      $digest_info['nc'], $digest_info['cnonce'], $digest_info['qop'], 
                      md5($A2))));

    // Porwnanie wartoci przesanej i obliczonej
    if ($request_digest != $digest_info['response']) {
        return false;
    }

    // Weryfikacja zakoczona pomylnie. Zwrcenie nazwy uytkownika.
    return $digest_info['username'];
}
?>
